/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.taxud.cesop.validation;

import eu.europa.ec.taxud.cesop.domain.MessageTypeEnum;
import eu.europa.ec.taxud.cesop.domain.MessageTypeIndicEnum;
import eu.europa.ec.taxud.cesop.domain.ValidationError;
import eu.europa.ec.taxud.cesop.domain.XmlMessageSpec;
import eu.europa.ec.taxud.cesop.domain.XmlPaymentDataMsg;
import eu.europa.ec.taxud.cesop.readers.PspXmlReader;
import eu.europa.ec.taxud.cesop.validation.CesopTooManyErrorsException;
import eu.europa.ec.taxud.cesop.validation.CesopValidationException;
import eu.europa.ec.taxud.cesop.validation.ExceptionHandler;
import eu.europa.ec.taxud.cesop.validation.IPspFileValidator;
import eu.europa.ec.taxud.cesop.validation.PspValidatingReader;
import eu.europa.ec.taxud.cesop.validation.PspValidationResult;
import eu.europa.ec.taxud.cesop.validation.ValidationSettings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;

public class PspFileValidator
implements IPspFileValidator {
    private static final String GENERIC_MS = "BE";
    private static final String UUID_V4_ZERO = "00000000-0000-4000-8000-000000000000";
    final int numberTransactionsByPspPart;
    final String defaultCountry;
    final ValidationSettings validationSettings;

    public PspFileValidator(int numberTransactionsByPspPart, ValidationSettings validationSettings, String defaultCountry) {
        this.numberTransactionsByPspPart = numberTransactionsByPspPart;
        this.validationSettings = validationSettings;
        this.defaultCountry = defaultCountry;
    }

    public static PspFileValidator createDefault() {
        int numberTransactionsByPspPart = 1000;
        return new PspFileValidator(1000, ValidationSettings.createDefault(), GENERIC_MS);
    }

    @Override
    public PspValidationResult validate(File pspFile) {
        PspValidationResult pspValidationResult;
        block9: {
            if (!pspFile.exists() || !pspFile.isFile()) {
                throw new CesopValidationException("The provided path is not a file: " + pspFile.getAbsolutePath());
            }
            InputStream inputStream = Files.newInputStream(pspFile.toPath(), new OpenOption[0]);
            try {
                pspValidationResult = this.validate(inputStream, pspFile.length());
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new CesopValidationException(e.getMessage());
                }
            }
            inputStream.close();
        }
        return pspValidationResult;
    }

    public PspValidationResult validate(InputStream inputStream, long contentLength) {
        String messageRefId = null;
        XmlMessageSpec xmlMessageSpec = null;
        PspValidatingReader validationReader = null;
        MessageTypeEnum messageType = null;
        PspXmlReader pspXmlReader = new PspXmlReader(inputStream, contentLength, this.numberTransactionsByPspPart, true);
        try {
            Object iterator;
            xmlMessageSpec = pspXmlReader.getXmlMessageSpec();
            messageRefId = xmlMessageSpec.getMessageRefId();
            messageType = xmlMessageSpec.getMessageType();
            validationReader = new PspValidatingReader(pspXmlReader, this.validationSettings, messageType.isBusinessRulesCheckEnabled(), null);
            if (messageType.isBusinessRulesCheckEnabled() && validationReader.getValidationErrors().isEmpty()) {
                iterator = validationReader.validateParts();
                while (iterator.hasNext()) {
                    iterator.next();
                }
            }
            iterator = new PspValidationResult(this.createPaymentDataMsg(xmlMessageSpec), validationReader.getValidationErrors(), messageType);
        }
        catch (Throwable iterator) {
            try {
                try {
                    pspXmlReader.close();
                }
                catch (Throwable throwable) {
                    iterator.addSuppressed(throwable);
                }
                throw iterator;
            }
            catch (Exception e) {
                if (validationReader != null) {
                    if (e instanceof CesopTooManyErrorsException) {
                        return new PspValidationResult(this.createPaymentDataMsg(xmlMessageSpec), validationReader.getValidationErrors(), messageType);
                    }
                    ValidationError validationError = ExceptionHandler.handleException(e, messageRefId);
                    validationReader.getValidationErrors().add(validationError);
                    return new PspValidationResult(this.createPaymentDataMsg(xmlMessageSpec), validationReader.getValidationErrors(), messageType);
                }
                return new PspValidationResult(this.createPaymentDataMsg(xmlMessageSpec), Collections.singletonList(ExceptionHandler.handleException(e, messageRefId)), messageType);
            }
        }
        pspXmlReader.close();
        return iterator;
    }

    private XmlPaymentDataMsg createPaymentDataMsg(XmlMessageSpec xmlMessageSpec) {
        XmlPaymentDataMsg paymentDataMsg = new XmlPaymentDataMsg();
        if (xmlMessageSpec == null) {
            paymentDataMsg.setCesopVersion("4.03");
            paymentDataMsg.setCountry(this.defaultCountry);
            paymentDataMsg.setMessageRefId(UUID_V4_ZERO);
            paymentDataMsg.setMessageType(MessageTypeIndicEnum.CESOP100.getLabel());
            paymentDataMsg.setReportingPeriod(this.validationSettings.getBusinessMinPeriod());
        } else {
            paymentDataMsg.setCesopVersion(xmlMessageSpec.getXsdVersion());
            paymentDataMsg.setCountry(xmlMessageSpec.getTransmittingCountry());
            paymentDataMsg.setMessageType(xmlMessageSpec.getMessageTypeIndic().getLabel());
            paymentDataMsg.setMessageRefId(xmlMessageSpec.getMessageRefId());
            paymentDataMsg.setReportingPeriod(xmlMessageSpec.getReportingPeriod());
            if (xmlMessageSpec.getSendingPsp() != null) {
                paymentDataMsg.setSendingPspIdentifier(xmlMessageSpec.getSendingPsp().getPspId().getValue());
                paymentDataMsg.setSendingPspIdentifierType(xmlMessageSpec.getSendingPsp().getPspId().getType());
                paymentDataMsg.setSendingPspIdentifierOther(xmlMessageSpec.getSendingPsp().getPspId().getOther());
                paymentDataMsg.setSendingPspNames(xmlMessageSpec.getSendingPsp().getNames());
            }
        }
        return paymentDataMsg;
    }
}

